using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.IO;
using System.Windows.Forms;
using System.Data;
using System.Text.RegularExpressions;

namespace Grep
{
	/// <summary>
	/// A simple none recursive grep tool example.
	/// Example submitted by Valentino Kyriakides
	///
	/// Possible enhancements as example exercises are, to
	/// add a recursion call to the directory processing.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.TextBox searchTextBox;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.TextBox pathTextBox;
		private System.Windows.Forms.TextBox resultTextBox;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Button dirButton;
		private System.Windows.Forms.Button grepButton;
		private System.Windows.Forms.TextBox fileMaskTextBox;
		private System.Windows.Forms.Label label4;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		Regex regexp;

		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.label1 = new System.Windows.Forms.Label();
			this.searchTextBox = new System.Windows.Forms.TextBox();
			this.label2 = new System.Windows.Forms.Label();
			this.pathTextBox = new System.Windows.Forms.TextBox();
			this.dirButton = new System.Windows.Forms.Button();
			this.grepButton = new System.Windows.Forms.Button();
			this.resultTextBox = new System.Windows.Forms.TextBox();
			this.label3 = new System.Windows.Forms.Label();
			this.fileMaskTextBox = new System.Windows.Forms.TextBox();
			this.label4 = new System.Windows.Forms.Label();
			this.SuspendLayout();
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(128, 56);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(184, 16);
			this.label1.TabIndex = 0;
			this.label1.Text = "Search Pattern (text or regexp) :";
			// 
			// searchTextBox
			// 
			this.searchTextBox.Location = new System.Drawing.Point(128, 72);
			this.searchTextBox.Name = "searchTextBox";
			this.searchTextBox.Size = new System.Drawing.Size(416, 20);
			this.searchTextBox.TabIndex = 1;
			this.searchTextBox.Text = "";
			this.searchTextBox.KeyDown += new System.Windows.Forms.KeyEventHandler(this.searchTextBox_KeyDown);
			this.searchTextBox.TextChanged += new System.EventHandler(this.searchTextBox_TextChanged);
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(8, 8);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(80, 16);
			this.label2.TabIndex = 2;
			this.label2.Text = "Directory Path:";
			// 
			// pathTextBox
			// 
			this.pathTextBox.Location = new System.Drawing.Point(8, 24);
			this.pathTextBox.Name = "pathTextBox";
			this.pathTextBox.Size = new System.Drawing.Size(544, 20);
			this.pathTextBox.TabIndex = 3;
			this.pathTextBox.Text = "";
			this.pathTextBox.KeyDown += new System.Windows.Forms.KeyEventHandler(this.pathTextBox_KeyDown);
			this.pathTextBox.TextChanged += new System.EventHandler(this.pathTextBox_TextChanged);
			// 
			// dirButton
			// 
			this.dirButton.Location = new System.Drawing.Point(560, 24);
			this.dirButton.Name = "dirButton";
			this.dirButton.Size = new System.Drawing.Size(56, 20);
			this.dirButton.TabIndex = 4;
			this.dirButton.Text = "...";
			this.dirButton.Click += new System.EventHandler(this.dirButton_Click);
			// 
			// grepButton
			// 
			this.grepButton.Enabled = false;
			this.grepButton.Location = new System.Drawing.Point(560, 64);
			this.grepButton.Name = "grepButton";
			this.grepButton.Size = new System.Drawing.Size(56, 48);
			this.grepButton.TabIndex = 5;
			this.grepButton.Text = "Do Grep";
			this.grepButton.Click += new System.EventHandler(this.grepButton_Click);
			//
			// resultTextBox
			// 
			this.resultTextBox.BackColor = System.Drawing.SystemColors.Info;
			this.resultTextBox.Location = new System.Drawing.Point(8, 128);
			this.resultTextBox.Multiline = true;
			this.resultTextBox.Name = "resultTextBox";
			this.resultTextBox.ReadOnly = true;
			this.resultTextBox.ScrollBars = System.Windows.Forms.ScrollBars.Both;
			this.resultTextBox.Size = new System.Drawing.Size(608, 216);
			this.resultTextBox.TabIndex = 6;
			this.resultTextBox.Text = "";
			this.resultTextBox.WordWrap = false;
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(8, 112);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(88, 16);
			this.label3.TabIndex = 7;
			this.label3.Text = "Search Result:";
			// 
			// fileMaskTextBox
			// 
			this.fileMaskTextBox.Location = new System.Drawing.Point(8, 72);
			this.fileMaskTextBox.Name = "fileMaskTextBox";
			this.fileMaskTextBox.Size = new System.Drawing.Size(96, 20);
			this.fileMaskTextBox.TabIndex = 8;
			this.fileMaskTextBox.Text = "*.cs";
			this.fileMaskTextBox.KeyDown += new System.Windows.Forms.KeyEventHandler(this.fileMaskTextBox_KeyDown);
			// 
			// label4
			// 
			this.label4.Location = new System.Drawing.Point(8, 56);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(56, 16);
			this.label4.TabIndex = 9;
			this.label4.Text = "File Mask:";
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(626, 349);
			this.Controls.Add(this.label4);
			this.Controls.Add(this.fileMaskTextBox);
			this.Controls.Add(this.label3);
			this.Controls.Add(this.resultTextBox);
			this.Controls.Add(this.grepButton);
			this.Controls.Add(this.dirButton);
			this.Controls.Add(this.pathTextBox);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.searchTextBox);
			this.Controls.Add(this.label1);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
			this.Name = "Form1";
			this.Text = "A Simple Grep";
			this.ResumeLayout(false);
		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

		/// <summary>
		/// Performs the event handling for the directory/file selection button.
		/// Navigate to a desired directory and choose a file with an appropriate
		/// extension, e.g. a csharp source file.
		/// </summary>
		private void dirButton_Click(object sender, System.EventArgs e)
		{
			OpenFileDialog fileDialog = new OpenFileDialog();
			fileDialog.Title = "Select a file with an appropriate extension:";
			fileDialog.InitialDirectory = Directory.GetCurrentDirectory();
			fileDialog.Filter = "All files (*.*)|*.*";
			if(fileDialog.ShowDialog() == DialogResult.OK)
			{
				String strFile = fileDialog.FileName;
				// A holder for the file extension
				String strExt;
				// Get a directory and file extension and place their
				// string representation into the corresponding text boxes
				pathTextBox.Text = Path.GetDirectoryName(strFile);
				strExt = Path.GetExtension(strFile);
				fileMaskTextBox.Text = "*" + strExt;
			}

		}

        /// <summary>
		/// Performs the event handling for the grep button.
		/// This invokes the grep search processing and also
		/// presents the grep output result formating.
		/// </summary>
		private void grepButton_Click(object sender, System.EventArgs e)
		{
        	DoGrep();
		}


		protected void GrepButtonStatus()
		{
			if (pathTextBox.Text != "" && searchTextBox.Text != "")
				grepButton.Enabled = true;
			else
				grepButton.Enabled = false;
		}

		protected void searchTextBox_TextChanged (object sender, System.EventArgs e)
		{
			GrepButtonStatus();
		}

		protected void pathTextBox_TextChanged (object sender, System.EventArgs e)
		{
			GrepButtonStatus();
		}

		protected void fileMaskTextBox_KeyDown (object sender, System.Windows.Forms.KeyEventArgs e)
		{
			if (e.KeyCode==Keys.Enter && grepButton.Enabled==true)
			{
				DoGrep();
			}
		}

		protected void pathTextBox_KeyDown (object sender, System.Windows.Forms.KeyEventArgs e)
		{
			if (e.KeyCode==Keys.Enter && grepButton.Enabled==true)
			{
				DoGrep();
			}
		}

		protected void searchTextBox_KeyDown (object sender, System.Windows.Forms.KeyEventArgs e)
		{
			if (e.KeyCode==Keys.Enter && grepButton.Enabled==true)
			{
				DoGrep();
			}
		}

		protected void DoGrep()
		{
        	// Define'S a reusable newline shortcut
			string NL = Environment.NewLine;
			// Check if the selected directory path exists
			String dirPathStr = pathTextBox.Text;
			if (!Directory.Exists(dirPathStr))
				MessageBox.Show("The directory does not exist!", "Simple Grep Error", MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
			else
			{
				regexp = new Regex(this.searchTextBox.Text);
				this.resultTextBox.Text = "";

				string[] fNames = Directory.GetFiles(pathTextBox.Text, fileMaskTextBox.Text);
				foreach (string fName in fNames )
				{
					StreamReader sr = null;
					try
					{
						sr = new StreamReader(
							new BufferedStream(
							new FileStream(
							fName, FileMode.Open)));
							
						string line = "";
						int lineCount = 0;
						int matchCount = 0;

						this.resultTextBox.AppendText(NL+"File: " +fName+NL+NL);

						while((line = sr.ReadLine()) != null)
						{
							lineCount++;
							if(regexp.IsMatch(line))
							{
								string outstr = String.Format("  line {0} -> {1}"+NL, lineCount, line);
								this.resultTextBox.AppendText(outstr);
								matchCount++;
							}
						}
						this.resultTextBox.AppendText(NL+"## "+matchCount+" matches found ##" + NL);
					}
					finally
					{
						sr.Close();
					}
				}
			}
		}


	}
}
